#============================================================================== 
# ** Ruby.Array.iterator
#------------------------------------------------------------------------------
# Description:
# ------------
# More Iterator Methods for the array class Iterator methods are methods that
# iterate over an object Each of these methods require a block as an example
#
#  anArray.each {|iterators| <code>}
#
#  anArray.each do |iterators|
#    code_to_execute
#  end
#
#  anArray.each { |iterators|
#    code_to_execute
#  }
#  
#  
# Method List:
# ------------
# each_nth_index
# each_nth_index_with_index
# each_ntuple
# each_pair
# each_triple
# each_with_array
# each_with_array_and_index
# each_with_next
# each_with_next_and_index
#==============================================================================

MACL::Loaded << 'Ruby.Array.iterator'

#============================================================================== 
# ** Array     
#==============================================================================

class Array
  #-------------------------------------------------------------------------
  #   Name      : Each Nth Index
  #   Info      : An Iterator Method calls block for every nth in the 
  #               array of arrays
  #   Author    : Trickster
  #   Call Info : Integer index the index to iterate over, A Block
  #-------------------------------------------------------------------------
  def each_nth_index(index)
    # Run Through Each Sub Array and return the value at index
    each {|array| yield(array[index])}
  end
  #-------------------------------------------------------------------------
  #   Name      : Each Nth Index with index
  #   Info      : An Iterator Method calls block for every nth in the 
  #               array of arrays with index
  #   Author    : Trickster
  #   Call Info : Integer index the index to iterate over, A Block
  #-------------------------------------------------------------------------
  def each_nth_index_with_index(index)
    # Run Through Each Sub Array and return the value at index
    each_with_index {|array, i| yield(array[index], i)}
  end
  #-------------------------------------------------------------------------
  #   Name      : Each N-tuple
  #   Info      : An Iterator Method calls block for every tuple in the array
  #   Author    : Trickster
  #   Call Info : Number an Integer value for how many to iterate over, A Block
  #-------------------------------------------------------------------------
  def each_ntuple(number)
    # Get Last Index (last index divisible by number)
    end_num = size - size % number - 1
    # Run Through each index 0, number, 2*number, ..., end_num 
    # and yield i, i+1, i+2, ... i + (number - 1)
    0.step(end_num, number) {|i| yield(*self[i, number])}
  end
  #-------------------------------------------------------------------------
  #   Name      : Each Pair
  #   Info      : An Iterator Method calls block for every pair in the array
  #   Author    : Trickster
  #   Call Info : A Block
  #-------------------------------------------------------------------------
  def each_pair
    # Get Last Index (last even numbered index)
    end_num = size - size % 2 - 1
    # Run Through each index 0, 2, 4, ..., end_num and yield i and i+1
    0.step(end_num, 2) {|i| yield(*self[i,2])}
  end
  #-------------------------------------------------------------------------
  #   Name      : Each Triple
  #   Info      : An Iterator Method calls block for every triple in the array
  #   Author    : Trickster
  #   Call Info : A Block
  #-------------------------------------------------------------------------
  def each_triple
    # Get Last Index (last index divisible by 3)
    end_num = size - size % 3 - 1
    # Run Through each index 0, 3, 6, ..., end_num and yield i, i+1, and i+2
    0.step(end_num, 3) {|i| yield(*self[i,3])}
  end
  #-------------------------------------------------------------------------
  #   Name      : Each With Array
  #   Info      : An Iterator Method calls block for each object in both arrays
  #   Author    : Trickster
  #   Call Info : Variable Amount, Object obj objects to be iterated over. A Block
  #-------------------------------------------------------------------------
  def each_with_array(*array)
    # Run Through Each Index and yield self at i and array at i
    each_index {|i| yield(self[i], array[i])}
  end
  #-------------------------------------------------------------------------
  #   Name      : Each With Array and Index
  #   Info      : An Iterator Method calls block for each object in both arrays
  #               with the index
  #   Author    : Trickster
  #   Call Info : Variable Amount, Object obj objects to be iterated over. A Block
  #-------------------------------------------------------------------------
  def each_with_array_and_index(*array)
    # Run Through Each Index and yield self at i and array at i and index
    each_index {|i| yield(self[i],array[i], i)}
  end
  #-------------------------------------------------------------------------
  #   Name      : Each With Next
  #   Info      : Runs Through with Next num elements
  #   Author    : Trickster
  #   Call Info : Integer num - next few elements to send as well
  #               A Block
  #-------------------------------------------------------------------------
  def each_with_next(num = 1)
    (size - num).times {|i| yield(*self[i..(i+num)])}
  end
  #-------------------------------------------------------------------------
  #   Name      : Each With Next And Index
  #   Info      : Runs Through with Next num elements with index
  #   Author    : Trickster
  #   Call Info : Integer num - next few elements to send as well
  #               A Block
  #-------------------------------------------------------------------------
  def each_with_next_and_index(num = 1)
    (size - num).times {|i| yield(*(self[i..(i+num)] << i))}
  end
end

